﻿using System;
using Microsoft.WindowsAzure.Storage.Table;

namespace VA.PPMS.IWS.TableService.Interface.Entities
{
    public class ActivityHistoryEntity : TableEntity
    {
        public enum ActivityType
        {
            // ReSharper disable once InconsistentNaming
            NPPES = 0,


            // ReSharper disable once InconsistentNaming
            LEIE = 1
        }

        public DateTime ActivityDate { get; set; }

        public ActivityHistoryEntity() {}

        public ActivityHistoryEntity(ActivityType activity, DateTime activityDate)
        {
            PartitionKey = activity.ToString();
            RowKey = activity.ToString();

            ActivityDate = activityDate;
        }
    }
}